Attribute VB_Name = "DesignTools"
'    This is a part of the source code for Pro/DESKTOP.
'    Copyright (C) 1999-2002 Parametric Technology Corporation.
'    All rights reserved.
Option Explicit

Private app As ProDESKTOP
Private ext As IProDExtensibility
Private uc1 As userCommand
Private uc2 As userCommand
Private uc3 As userCommand
Private uc4 As userCommand

Dim SliderForm As Object
Dim stepperform As Object
Dim EnlargementForm As Object

Public Sub OnStartUp()
    Set app = GetApp

    Set ext = app
    
    ext.ImportVBComponent app.GetAppExecutablePath + "\..\Documentation\Addins\Macros\DesignTools\AdjustSKDims.frm"
    ext.ImportVBComponent app.GetAppExecutablePath + "\..\Documentation\Addins\Macros\DesignTools\FeatureStepper.frm"
    ext.ImportVBComponent app.GetAppExecutablePath + "\..\Documentation\Addins\Macros\DesignTools\MirrorForm.frm"
    
    Set uc1 = ext.AddUserCommand(barDesign, menuDesignConstraint, -1, GetResourceString(50), "DesignTools", "DesignTools.ShowAdjustSKDims")
    Set uc2 = ext.AddUserCommand(barDrawing, menuDrawingConstraint, -1, GetResourceString(50), "DesignTools", "DesignTools.ShowAdjustSKDims")
    Set uc3 = ext.AddUserCommand(barDesign, menuDesignFeature, -1, GetResourceString(51), "DesignTools", "DesignTools.ShowStepper")
    Set uc4 = ext.AddUserCommand(barDesign, menuDesignAssembly, -1, GetResourceString(52), "DesignTools", "DesignTools.ShowMirrorForm")
    
    uc1.SetPrompt GetResourceString(50)
    uc2.SetPrompt GetResourceString(50)
    uc3.SetPrompt GetResourceString(51)
    uc4.SetPrompt GetResourceString(52)
End Sub

Public Sub OnCloseDown()
    Set app = GetApp
    Set ext = app
    
    Set uc1 = ext.GetUserCommand(barDesign, menuDesignConstraint, GetResourceString(50))
    Set uc2 = ext.GetUserCommand(barDrawing, menuDrawingConstraint, GetResourceString(50))
    Set uc3 = ext.GetUserCommand(barDesign, menuDesignFeature, GetResourceString(51))
    Set uc4 = ext.GetUserCommand(barDesign, menuDesignAssembly, GetResourceString(52))
    
    ext.RemoveVBComponent app.GetAppExecutablePath + "\..\Documentation\Addins\Macros\DesignTools\AdjustSKDims.frm"
    ext.RemoveVBComponent app.GetAppExecutablePath + "\..\Documentation\Addins\Macros\DesignTools\FeatureStepper.frm"
    ext.RemoveVBComponent app.GetAppExecutablePath + "\..\Documentation\Addins\Macros\DesignTools\MirrorForm.frm"
        
    ext.RemoveUserCommand uc1
    ext.RemoveUserCommand uc2
    ext.RemoveUserCommand uc3
    ext.RemoveUserCommand uc4
End Sub

Public Sub ShowAdjustSKDims()

    On Error GoTo errorHandler
    If SliderForm Is Nothing Then
        Set SliderForm = New AdjustSKDims
        SliderForm.Show
        Set SliderForm = Nothing
    End If
    On Error GoTo 0
Exit Sub
errorHandler:
    MsgBox GetResourceString(96)
End Sub

Public Sub ShowStepper()
    On Error GoTo errorHandler
    If stepperform Is Nothing Then
        Set stepperform = New FeatureStepper
        stepperform.Show
        Set stepperform = Nothing
    End If
    On Error GoTo 0
Exit Sub
errorHandler:
    MsgBox GetResourceString(96)
End Sub

Sub ShowMirrorForm()
    On Error GoTo errorHandler
    Dim mirrorDlg As New MirrorForm
    mirrorDlg.Show
    On Error GoTo 0
Exit Sub
errorHandler:
    MsgBox GetResourceString(96)
End Sub



